/**************************************************************************
 * Filename: PortConfig.h
 *
 * Description: Definition User define targets
 *
 * Copyright (c) 2012, Freescale Semiconductor, Inc. All rights reserved.
 *
 ***************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#ifndef PORTCONFIG_H_
#define PORTCONFIG_H_
#endif

/********************************************************************/
/* 
 * Include the generic CPU header file 
 */
#include "EmbeddedTypes.h"
#include "Interrupt.h"

/* 
 * Include common utilities
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "derivative.h"




#if 0
#if (gTarget_UserDefined_d == 1)

#define NotDefined 

////////////////////////////////////////
/////// Target Global Definitions //////
////////////////////////////////////////

/*
 *  Name: gSystemClk24MHz_c
 *  Description: 24 MHz system clock 
 */
#ifndef gSystemClk24MHz_c
#define gSystemClk24MHz_c                        24
#endif

/*
 *  Name: gSystemClk48MHz_c
 *  Description: 48 MHz system clock 
 */
#ifndef gSystemClk48MHz_c
#define gSystemClk48MHz_c                        48
#endif

/*
 *  Name: gSystemClk96MHz_c
 *  Description: 96 MHz system clock 
 */
#ifndef gSystemClk96MHz_c
#define gSystemClk96MHz_c                        96
#endif

/*
 * Name: gSystemClock_d
 * Description: Peripheral Bus Clock (MHz units)
 */
#ifndef gSystemClock_c
#define gSystemClock_c                           NotDefined    
#endif

/*
 * Name: gMhzToKHzConvert_c
 * Description: Specifies how many KHz are in 1 MHz
 */
#ifndef gMhzToKHzConvert_c
#define gMhzToKHzConvert_c      (1000)
#endif

////////////////////////////////////////
/////// Define LED port mapping ////////
////////////////////////////////////////

/*
 * LED Port Data Output register mapping
 */
#define gLED_PortDataOutReg_c           NotDefined

/*
 * LED Port Data Direction register mapping
 */
#define gLED_PortDataDirReg_c           NotDefined

/*
 * LED Port Data Set register mapping 
 */
#define gLED_PortDataSetReg_c           NotDefined

/*
 * LED Port Data Clear register mapping
 */
#define gLED_PortDataClearReg_c         NotDefined

/*
 * LED Port Data Toggle register mapping
 */
#define gLED_PortDataToggleReg_c        NotDefined

/*
 * LED 1 pin definition
 */
#define gLED_Led1Pin_c                  NotDefined

/*
 * LED 2 pin definition
 */
#define gLED_Led2Pin_c                  NotDefined

/*
 * LED 3 pin definition
 */
#define gLED_Led3Pin_c                  NotDefined

/*
 * LED 4 pin definition
 */
#define gLED_Led4Pin_c                  NotDefined

/*
 * LED 1 Pin Control register mapping
 */
#define gLED_Led1PinCtrlReg_c           NotDefined

/*
 * LED 2 Pin Control register mapping
 */
#define gLED_Led2PinCtrlReg_c           NotDefined

/*
 * LED 3 Pin Control register mapping
 */
#define gLED_Led3PinCtrlReg_c           NotDefined

/*
 * LED 4 Pin Control register mapping
 */
#define gLED_Led4PinCtrlReg_c           NotDefined

/*
 * LED port clock gating register mapping
 */
#define gLED_ClkGatingReg_c             NotDefined

/*
 * LED port clock gating bit 
 */
#define gLED_ClkGatingBit_c             NotDefined

/*
 * LED Pin Control Alternate Function
 */
#define gLED_PinCtrlAltFunc_c           NotDefined

/*
 * LEDs count on target board
 */
#define gLEDsOnTargetBoardCnt_c         NotDefined

////////////////////////////////////////
//// Define KEYBOARD port mapping //////
////////////////////////////////////////

/*
 * Keyboard (TSI) clock gating register
 */
#define gTSI_ClkGatingReg_c             NotDefined

/*
 * Keyboard (TSI) clock gating bit
 */
#define gTSI_ClkGatingBit_c             NotDefined

/*
 * TSI Electrodes Pin Control Registers 
 */
#define gTSI_Electrode_0_PinCtrlReg     NotDefined
#define gTSI_Electrode_1_PinCtrlReg     NotDefined
#define gTSI_Electrode_2_PinCtrlReg     NotDefined
#define gTSI_Electrode_3_PinCtrlReg     NotDefined

////////////////////////////////////////
/////// Define SPI port mapping ////////
////////////////////////////////////////

/*
 *  SPI PCS Pin Control Register mapping
 */
#define SPI_PCS_PCR                     NotDefined
#define SPI_PCS_ALT_FUNC                NotDefined

/*
 *  SPI SCK Pin Control Register mapping
 */
#define SPI_SCK_PCR                     NotDefined
#define SPI_SCK_ALT_FUNC                NotDefined

/*
 *  SPI SOUT (MOSI) Pin Control Register mapping
 */
#define SPI_SOUT_PCR                    NotDefined
#define SPI_SOUT_ALT_FUNC               NotDefined

/*
 * SPI SIN (MISO) Pin Control Register mapping
 */
#define SPI_SIN_PCR                     NotDefined
#define SPI_SIN_ALT_FUNC                NotDefined

/*
 * Name: gSPI_Slave_TxDataAvailableSignal_Enable_d
 * Description: Slave transmitter can signal to the master if there's data available
 */
#ifndef gSPI_Slave_TxDataAvailableSignal_Enable_d
#define gSPI_Slave_TxDataAvailableSignal_Enable_d       NotDefined
#endif

#if (gSPI_Slave_TxDataAvailableSignal_Enable_d == TRUE)

/*
 * Name: gSPI_DataAvailablePortDataINReg_c  
 * Description: Port Data Input register mapping
 */
#ifndef gSPI_DataAvailablePortDataINReg_c
#define gSPI_DataAvailablePortDataINReg_c               NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePortDataOUTReg_c 
 * Description: Port Data Output register mapping
 */
#ifndef gSPI_DataAvailablePortDataOUTReg_c
#define gSPI_DataAvailablePortDataOUTReg_c              NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePortDDirReg_c
 * Description: Port Data Direction register mapping
 */
#ifndef gSPI_DataAvailablePortDDirReg_c
#define gSPI_DataAvailablePortDDirReg_c                 NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePinMask_c
 * Description: Port Data register pin mask
 */
#ifndef gSPI_DataAvailablePinMask_c
#define gSPI_DataAvailablePinMask_c                     NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePinCtrlReg_c
 * Description: Pin Control register mapping
 */
#ifndef gSPI_DataAvailablePinCtrlReg_c
#define gSPI_DataAvailablePinCtrlReg_c                  NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePinCtrlMask_c
 * Description: Pin Control register mask
 */
#ifndef gSPI_DataAvailablePinCtrlMask_c
#define gSPI_DataAvailablePinCtrlMask_c                 NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePinCtrlValue_c
 * Description: Pin Control register value
 */
#ifndef gSPI_DataAvailablePinCtrlValue_c
#define gSPI_DataAvailablePinCtrlValue_c                NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePortClkGatingReg_c
 * Description: Clock Gating Control register mapping
 */
#ifndef gSPI_DataAvailablePortClkGatingReg_c
#define gSPI_DataAvailablePortClkGatingReg_c            NotDefined
#endif

/*
 * Name: gSPI_DataAvailablePortClkGatingBit_c
 * Description: Clock Gating Control register bit
 */
#ifndef gSPI_DataAvailablePortClkGatingBit_c
#define gSPI_DataAvailablePortClkGatingBit_c            NotDefined
#endif


#endif /* gSPI_Slave_TxDataAvailableSignal_Enable_d */

#endif /* gTarget_UserDefined */
#endif
